![[Pasted image 20250421194042.png]]
## Purpose
- Protects against large-scale virus outbreaks and smaller non-viral attacks such as phishing and malware distribution.
- Provides real-time updates to prevent harmful messages from reaching users.

![[Pasted image 20250421192622.png]]

## Features and Functionality

##### Real-Time Data Collection
- Uses global traffic patterns to identify and quarantine potential outbreak messages.
- Quarantines messages until deemed safe based on updated information or antivirus definitions.
##### Non-Viral Threat Detection
- Detects phishing scams and malware links using legitimate-looking designs and custom URLs.
- Rewrites URLs to redirect traffic through a web security proxy, warning users of potential threats.

### Categories of Protection
- **Virus Outbreaks**: Messages with never-before-seen viruses or variants.
- **Non-Viral Threats**: Phishing attempts, scams, and malware distribution through suspicious links.

## Tactics for Protection
##### Delay
- Quarantines suspicious messages during the vulnerable period before updated rules are released.
- Allows time for linked malicious websites to go offline or be blocked.
##### Redirect
- Scans messages for URLs and evaluates threat levels.
- Rewrites URLs to redirect to a web security proxy with warning splash screens.
##### Modify
- Alerts users to suspected threats by modifying message content and subject headers.
- Adds disclaimers to message bodies.

## Rules and Detection

##### Outbreak and Adaptive Rules
- **Outbreak Rules**: Generated by Cisco TOC (Threat Operation Center) , focusing on message characteristics to detect outbreaks.
- **Adaptive Rules**: Compare message attributes to known outbreak messages for detection.
##### Example Characteristics
- File type, size, keywords, URL patterns, and suspicious headers.

## Processing Flow

##### Email Pipeline
- Messages pass through antispam and antivirus engines before Outbreak Filters.
- CASE evaluates messages using outbreak and adaptive rules to assign threat levels.
##### Quarantine and Rescan
- Reevaluates quarantined messages against updated rules to determine threat levels.
- Uses intelligent algorithms to assign final threat levels.

## Management and Configuration

##### Quarantine Settings
- Configurable threat level thresholds for quarantining messages.
- Retention times for viral and non-viral threat messages.
- Options to deliver non-viral threat messages immediately without quarantine.

![[Pasted image 20250421193130.png]]

##### Exemptions
- Specific file extensions and domains can be exempted from processing.
- Bypassed files are still processed by other email security pipeline features.

## Recommendations
- Regularly monitor outbreak quarantine, especially during virus outbreaks.
- Configure quarantine settings to minimize message delays and avoid deleting legitimate messages.

